#ifndef __i2c_h
#define __i2c_h

#include "msg_queues.h"

#define MAXI2CBUF MSGLEN

#define I2C_IDLE            0x5
#define I2C_STARTED         0x6
#define	I2C_RCV_DATA        0x7
#define I2C_SEND_DATA       0x8
#define I2C_SEND_ADDR       0x9
#define I2C_CHECK_ACK       0xB
#define I2C_REQ_DATA        0xC
#define I2C_SEND_STOP       0xD

#define I2C_MODE_SLAVE      0x10
#define I2C_MODE_MASTER     0x11

#define I2C_MASTER_SEND     0x20
#define I2C_MASTER_RECV     0x21
#define I2C_MASTER_IDLE     0x22

#define I2C_ERR_THRESHOLD   1
#define I2C_ERR_OVERRUN     0x4
#define I2C_ERR_NOADDR      0x5
#define I2C_ERR_NODATA      0x6
#define I2C_ERR_MSGTOOLONG  0x7
#define I2C_ERR_MSG_TRUNC   0x8

typedef struct __I2C_DATA {
    unsigned char *buffer;
    int buflen;
    unsigned char status;
    unsigned char bufind;
    unsigned char slave_event_count;
    unsigned char slave_error_code;
    unsigned char slave_error_count;
    unsigned char slave_in_last_byte;
    unsigned char slave_outbufmsgtype;
    unsigned char slave_sending_data;
    unsigned char slave_sending_blank_data;

    unsigned char master_dest_addr;
    unsigned char master_state;
    unsigned char mode;
} I2C_DATA; // 16 bytes overhead

void i2c_init(I2C_DATA *);
void i2c_interrupt_handler(void);
void i2c_interrupt_slave(void);
void i2c_interrupt_master(void);
void i2c_configure_slave(unsigned char);
void i2c_configure_master(void);
void i2c_master_send(unsigned char address, unsigned char length,unsigned char *msg);
void i2c_master_recv(unsigned char address, unsigned char length);
unsigned char i2c_master_busy(void);

#endif